<?php
use App\Http\Controllers\ApiController;
use App\Http\Controllers\Api\AccountController;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\BackupController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CustomBillController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\CustomProductController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\ImageController;
use App\Http\Controllers\Api\ImportController;
use App\Http\Controllers\Api\InvoicePrintController;
use App\Http\Controllers\Api\LanguageController;
use App\Http\Controllers\Api\Language\LanguageController as LocaleController;
use App\Http\Controllers\Api\Media\MediaController;
use App\Http\Controllers\Api\PosController;
use App\Http\Controllers\Api\ProductAttributeController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\RepairController;
use App\Http\Controllers\Api\SaleOrderController;
use App\Http\Controllers\Api\SettingController;
use App\Http\Controllers\Api\StockController;
use App\Http\Controllers\Api\SupplierController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\UserRoleController;
use App\Http\Controllers\Api\WarehouseController;
use Illuminate\Support\Facades\Route;

Route::get('system-config', [ApiController::class, 'protection'])->name('system.config');

Route::group(['middleware' => 'isAjax', 'prefix' => config('app.version', 'codehas')], function () {

    Route::post('/repair-track-status', [RepairController::class, 'track'])->name('repair-order.track');

    Route::group(['prefix' => 'auth', 'namespace' => 'Auth'], function () {
        Route::post('login', [AuthController::class, 'login'])->name('auth.login');
        Route::post('logout', [AuthController::class, 'logout'])->name('auth.logout');
        Route::post('register', [AuthController::class, 'register'])->name('auth.register');
        Route::post('recover', [AuthController::class, 'recover'])->name('auth.recover');
        Route::post('reset', [AuthController::class, 'reset'])->name('auth.reset');
        Route::get('user', [AuthController::class, 'user'])->name('auth.user');
        Route::post('check', [AuthController::class, 'check'])->name('auth.check');
    });

    Route::group(['prefix' => 'print'], function () {
        Route::get('/sale-orders/{saleOrder}', [InvoicePrintController::class, 'saleOrder'])->name('print-sale-order');

        Route::get('/repair-orders/{repair}', [InvoicePrintController::class, 'repairOrder'])->name('print-repair-order');
        Route::get('/custom-bill-orders/{customBill}', [InvoicePrintController::class, 'customBillOrder'])->name('print-custom-bill-order');
        Route::get('/custom-buy-orders/{customProduct}', [InvoicePrintController::class, 'customBuyProduct'])->name('print-custom-product-order');
        Route::get('/report-card', [InvoicePrintController::class, 'reportCard'])->name('print-report-card');
    });

    Route::group(['prefix' => 'lang', 'namespace' => 'Language'], function () {
        Route::get('/', [LocaleController::class, 'languageList'])->name('language.list');
        Route::get('/{lang}', [LocaleController::class, 'get'])->name('language.get');
        Route::post('/set-language', [LocaleController::class, 'set'])->name('set-locale');
    });

    Route::group(['middleware' => 'auth:sanctum'], function () {
        Route::post('upload-image', [ImageController::class, 'upload'])->name('upload-image');

        Route::get('files/{file}', [MediaController::class, 'show'])->name('files.show');
        Route::post('files', [MediaController::class, 'store'])->name('files.store');
        Route::post('files/attachments', [MediaController::class, 'uploadAttachment'])->name('file.upload-attachment');

        Route::group(['prefix' => 'pos'], function () {
            Route::get('get-products', [PosController::class, 'products'])->name('pos.products');
            Route::get('get-categories', [PosController::class, 'categories'])->name('pos.categories');
            Route::post('scan-barcode', [PosController::class, 'scanBarcode'])->name('scan-barcode');
            Route::get('customers', [PosController::class, 'customers'])->name('pos.customers');
        });

        Route::group(['prefix' => 'account'], function () {
            Route::post('update', [AccountController::class, 'update'])->name('account.update');
            Route::post('password', [AccountController::class, 'password'])->name('account.password');
        });

        Route::group(['prefix' => 'admin'], function () {

            Route::get('product-stock-alerts', [ProductAttributeController::class, 'stockAlerts'])->name('get-stock-alerts');

            Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard.data');

            Route::get('backups', [BackupController::class, 'index'])->name('backup.index');
            Route::post('backups', [BackupController::class, 'generate'])->name('backup.generate');
            Route::patch('backups/{file}/restore', [BackupController::class, 'restore'])->name('backup.restore');
            Route::post('backups/{file}/remove', [BackupController::class, 'destroy'])->name('backup.destroy');
            Route::get('users/user/roles', [UserController::class, 'userRoles'])->name('users.user-roles');
            Route::get('users/list', [UserController::class, 'users'])->name('users.list');
            Route::get('roles/permissions', [UserRoleController::class, 'permissions'])->name('user-roles.permissions');
            Route::post('languages/sync', [LanguageController::class, 'sync'])->name('language.sync');

            Route::group(['prefix' => 'settings-app'], function () {
                Route::get('setup', [SettingController::class, 'getAppSetup'])->name('get-app-setup');
                Route::post('setup', [SettingController::class, 'setAppSetup'])->name('set-app-setup');
                Route::get('configs', [SettingController::class, 'getAppConfigs'])->name('get-app-configs');
                Route::post('configs', [SettingController::class, 'setAppConfigs'])->name('set-app-configs');
                Route::get('printer', [SettingController::class, 'getAppPrinter'])->name('settings.get.printer');
                Route::post('printer', [SettingController::class, 'setAppPrinter'])->name('settings.set.printer');

                Route::get('terms', [SettingController::class, 'getInvoiceTerms'])->name('settings.get.terms');
                Route::post('terms', [SettingController::class, 'setInvoiceTerms'])->name('settings.set.terms');

                Route::get('templates', [SettingController::class, 'getNotificationTemplates'])->name('settings.get.templates');
                Route::post('templates', [SettingController::class, 'setNotificationTemplates'])->name('settings.set.templates');

                Route::post('termial', [SettingController::class, 'optimize'])->name('settings.optimize');
                Route::get('user-roles', [SettingController::class, 'userRoles'])->name('settings.user-roles');
                Route::get('languages', [SettingController::class, 'languages'])->name('settings.languages');
            });

            Route::get('/stocks-list', [StockController::class, 'stockList'])->name('stock.list');
            Route::get('/warehouses-list', [WarehouseController::class, 'warehouseList'])->name('warehouses.list');
            Route::get('product-categories', [CategoryController::class, 'categories'])->name('product.categories');
            Route::get('product-suppliers', [SupplierController::class, 'suppliers'])->name('product.suppliers');
            Route::post('products/{product}/image', [ProductController::class, 'imageUpdate'])->name('products.image');
            Route::post('exports', [ImportController::class, 'export'])->name('exports');
            Route::post('imports', [ImportController::class, 'imports'])->name('imports');
            Route::post('import/{product}/product-attributes', [ImportController::class, 'productAttributes'])->name('product-attributes.import');
            Route::post('batch-varients/{product}', [ProductAttributeController::class, 'batchStore'])->name('batach-varient-store');
            Route::get('customers-paginator', [CustomerController::class, 'paginater'])->name('customers.paginater');

            Route::delete('product-rows-destroy', [ProductController::class, 'destroyBatch'])->name('products.rows.destroy');
            Route::delete('category-rows-destroy', [CategoryController::class, 'destroyBatch'])->name('categories.rows.destroy');
            Route::delete('warehouse-rows-destroy', [WarehouseController::class, 'destroyBatch'])->name('warehouses.rows.destroy');
            Route::delete('suppliers-rows-destroy', [SupplierController::class, 'destroyBatch'])->name('suppliers.rows.destroy');
            Route::delete('customers-rows-destroy', [CustomerController::class, 'destroyBatch'])->name('customers.rows.destroy');

            Route::post('sales-rows-destroy', [SaleOrderController::class, 'destroyBatch'])->name('sale.rows.destroy');
            Route::post('bills-rows-destroy', [CustomBillController::class, 'destroyBatch'])->name('bills.rows.destroy');

            Route::post('repairs-rows-destroy', [RepairController::class, 'destroyBatch'])->name('repair.rows.destroy');
            Route::apiResource('repairs', RepairController::class);

            Route::post('custom-products-rows-destroy', [CustomProductController::class, 'destroyBatch'])->name('custom-products.rows.destroy');
            Route::apiResource('custom-products', CustomProductController::class);
            Route::get('product-labale-list', [ProductController::class, 'getLabelList'])->name('products.labels');

            Route::apiResource('suppliers', SupplierController::class);
            Route::apiResource('sale-orders', SaleOrderController::class)->except('update');

            Route::apiResource('product-attributes', ProductAttributeController::class);
            Route::apiResource('customers', CustomerController::class);

            Route::apiResource('custom-bills', CustomBillController::class);
            Route::apiResource('categories', CategoryController::class);
            Route::apiResource('products', ProductController::class);
            Route::apiResource('stocks', StockController::class);
            Route::apiResource('warehouses', WarehouseController::class);
            Route::apiResource('users', UserController::class);
            Route::apiResource('user-roles', UserRoleController::class);
            Route::apiResource('languages', LanguageController::class);
        });
    });
});
