<?php

namespace Database\Seeders;

use App\Models\UserRole;
use Illuminate\Database\Seeder;

class UserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (UserRole::count() !== 0) {
            return;
        }
        UserRole::create(
            [
                'name' => 'Admin',
                'is_primary' => true,
                'admin_access' => true,
                'permissions' => [], //has all permissions
            ]
        );
        UserRole::create(
            [
                'name' => 'Customer',
                'is_primary' => false,
                'admin_access' => false,
                'permissions' => [''],
            ]
        );
    }
}
