<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Setting::count() !== 0) {
            return;
        }
        Setting::create(
            [
                'app_https' => false,
                'app_name' => 'Repairshop solution',
                'app_url' => config('app.url'),
                'app_phone' => '7866718114',
                'app_date_format' => 'd:m:Y H:s:i',
                'app_address' => '4466 Scutcheon Drive Centennial, CO 80112',
                'tax_rate' => 0,
                'mail_from_name' => 'Repairshop solution',
                'mail_from_address' => 'mail@domain.com',
                'mail_mailer' => 'log',
                'mail_host' => '0.0.0.0',
                'mail_username' => null,
                'mail_password' => null,
                'mail_port' => 1025,
                'mail_encryption' => null,
                'invoice_setup' => [
                    "print_font_family" => "monospace",
                    "invoice_shop_name_address_size" => "20",
                    "invoice_header_footer_size" => "17",
                    "inovice_items_font_size" => "15",
                    "invoice_paper_width" => "80mm",
                    "invoice_paper_height" => "190mm",
                    "invoice_shop_name_address_position" => "center",
                ],
            ]
        );
    }
}
