<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('custom_products', function (Blueprint $table) {
            $table->id();
            $table->string('key');
            $table->string('uuid');

            $table->string('model');
            $table->string('imei')->nullable();
            $table->string('serial_number')->nullable();
            $table->string('grade')->nullable();
            $table->string('condition')->nullable();
            $table->string('more')->nullable();

            $table->float('cost');
            $table->float('price');
            $table->string('qty')->default(1);

            $table->longText('sign')->nullable();
            $table->boolean('is_sold')->default(false);

            $table->string('image')->nullable();
            $table->string('docs')->nullable();

            $table->foreignId('customer_id')->nullable()->constrained('customers');
            $table->foreignId('cash_book_id')->nullable()->constrained('cash_books');
            $table->foreignId('user_id')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('custom_products');
    }
}
