<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRepairsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('repairs', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->string('tracking');
            $table->float('charges')->default(0);
            $table->float('pre_paid')->default(0);
            $table->float('total_amount')->default(0);
            $table->float('due')->default(0);
            $table->text('tax')->nullable();
            $table->float('tax_amount')->default(0);
            $table->text('issue');
            $table->text('message')->nullable();
            $table->string('device_name');
            $table->string('serial_number');
            $table->string('imei');
            $table->boolean('status')->default(0);
            $table->boolean('is_cash_paid')->default(true);
            $table->float('profit')->default(0);
            $table->float('cost')->default(0);
            $table->foreignId('customer_id')->nullable()->constrained('customers');
            $table->foreignId('cash_book_id')->nullable()->constrained('cash_books');
            $table->foreignId('user_id')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('repairs');
    }
}
