<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCashBooksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cash_books', function (Blueprint $table) {
            $table->id();
            $table->string('uuid');
            $table->foreignId('user_id')->nullable()->constrained('users');
            $table->float('total_cash_in');
            $table->float('total_sale_amount')->default(0);
            $table->float('total_repair_amount')->default(0);
            $table->float('total_bill_amount')->default(0);
            $table->float('total_refund_amount')->default(0);
            $table->float('total_custom_purchase_amount')->default(0);
            $table->float('total_cash_out')->default(0);
            $table->float('cash_in_till')->default(0);
            $table->float('cash_in_card')->default(0);
            $table->boolean('closed')->default(false);
            $table->float('total_due_recovery_in_card')->default(0);
            $table->float('total_due_recovery_in_cash')->default(0);
            $table->float('expense_amount')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cash_books');
    }
}
