<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('slug')->unique();
            $table->integer('category_id')->nullable();
            $table->integer('subcategory_id')->nullable();
            $table->longtext('description')->nullable();
            $table->integer('low_qty_alert')->default(5);
            $table->string('unit')->nullable();
            $table->boolean('status')->default(0);
            $table->boolean('tax_type')->default(false);
            $table->boolean('has_variants')->default(0);
            $table->string('sku')->nullable();
            $table->string('upc')->nullable();
            $table->decimal('cost', 8, 2)->nullable();
            $table->decimal('price', 8, 2)->nullable();
            $table->decimal('ws_price', 8, 2)->nullable();
            $table->boolean('is_serial_based')->default(0);
            $table->string('serial_number')->nullable();
            $table->string('identity')->nullable();
            $table->string('image')->nullable();
            $table->string('barcode_symbology')->default('CODE128');
            $table->integer('supplier_id')->nullable();
            $table->integer('warehouse_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
