<?php

namespace App\Traits;

trait DurationScopeTrait
{
    public function scopeDuration($query, $value, $isLast = false)
    {
        $date = now();
        if ($isLast) {
            if ('year' == $value) {
                $date = $date->subYear();
            } elseif ('month' == $value) {
                $date = $date->subMonth();
            } elseif ('day' == $value) {
                $date = $date->subDay();
            }
        }

        if ('day' == $value) {
            return $query->whereDate('created_at', '=', $date->format('Y-m-d'));
        }
        if ('month' == $value) {
            return $query->whereMonth('created_at', '=', $date->month);
        }
        if ('year' == $value) {
            return $query->whereYear('created_at', '=', $date->year);
        }

        return $query;
    }
}
