<?php

namespace App\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Warehouse extends Model
{
    use Filterable;

    protected $fillable = [
        'name',
        'max_volume',
        'location',
    ];

    /**
     * Stock information existing in warehouse
     *
     * @return     HasMany  The has many.
     */
    public function stocks(): HasMany
    {
        return $this->hasMany(Stock::class);
    }

    public function products(): HasMany
    {
        return $this->hasMany(Stock::class);
    }

    public function productAttributes(): HasMany
    {
        return $this->hasMany(Stock::class);
    }

    public function totalStockQty()
    {
        return collect($this->stocks)->sum('quantity');
    }
}
