<?php

namespace App\Models;

use dacoto\EnvSet\Facades\EnvSet;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = [
        'app_name',
        'app_address',
        'app_phone',
        'app_https',
        'app_url',
        'app_about',
        'app_date_format',
        'app_date_locale', 'app_direction',
        'app_default_role',
        'app_background',
        'app_icon',
        'app_locale',
        'app_timezone',
        'app_user_registration',
        'pos_scanner_focus_autofocus',
        'pos_scanner_focus_duration',
        'pos_scanner_processing_delay',
        'default_warehouse_id',
        'pos_categories_default_numbers',
        'pos_products_default_numbers', 'pos_monies',

        'currency_symbol',
        'currency_symbol_on_left',
        'currency_shorthand_notation',
        'currency_space_between',

        'tax_rate',
        'is_tax_fix',
        'tax_id',
        'is_vat',
        'is_tax_included',

        'queue_connection',
        'mail_from_name',
        'mail_from_address',
        'mail_mailer',
        'mail_host',
        'mail_username',
        'mail_password',
        'mail_port',
        'mail_encryption',
        'mailgun_domain',
        'mailgun_endpoint',
        'mailgun_secret',

        'recaptcha_enabled',
        'recaptcha_public',
        'recaptcha_private',

        'repair_invoice_terms',
        'bill_invoice_terms',
        'sale_invoice_terms',
        'custom_buy_invoice_terms',
        'print_font_family',
        'print_font_size',
        'print_font_color',
        'print_printer_width',
        'print_printer_height',
        'print_qr_code_size',

        'invoice_setup',

    ];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    protected static function boot(): void
    {
        parent::boot();

        /*
         * Register an updated model event with the dispatcher.
         *
         * @param \Closure|string $callback
         * @return void
         */
        self::updating(
            static function ($model) {
                $writeable = [
                    'app_url', 'app_name', 'app_https', 'app_direction',
                    'app_timezone', 'app_locale', 'app_date_format',
                    'mail_from_address', 'mail_from_name',
                    'mail_mailer', 'mail_encryption',
                    'mail_host', 'mail_password',
                    'mail_port', 'mail_username',
                    'mailgun_domain', 'mailgun_secret',
                    'mailgun_endpoint',
                    'product_barcode_length',
                ];
                $writeable = collect($model)->only($writeable)->all();
                foreach ($writeable as $key => $value) {
                    EnvSet::setKey(strtoupper($key), $value);
                    EnvSet::save();
                }
            }
        );
    }

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'app_user_registration' => 'boolean',
        'recaptcha_enabled' => 'boolean',
        'currency_symbol_on_left' => 'boolean',
        'is_vat' => 'boolean',
        'is_fix' => 'boolean',
        'is_tax_fix' => 'boolean',
        'is_tax_included' => 'boolean',
        'app_https' => 'boolean',
        'repair_invoice_terms' => 'json',
        'bill_invoice_terms' => 'json',
        'sale_invoice_terms' => 'json',

        'currency_symbol_on_left' => 'boolean',
        'currency_shorthand_notation' => 'boolean',
        'currency_space_between' => 'boolean',

        'custom_buy_invoice_terms' => 'json',
        'pos_scanner_focus_autofocus' => 'boolean',
        'sms_status' => 'boolean',

        'invoice_setup' => 'json',

    ];

    /**
     * Application icon URL
     *
     * @param mixed $icon icon
     *
     * @return string
     */
    public function getLogoUrl(): string
    {
        return $this->app_icon
        ? url('storage/' . $this->app_icon)
        : asset('images/default/logo.png');
    }

    /**
     * Application background image URL
     *
     * @param mixed $background background
     *
     * @return string
     */
    public function getBackgroundUrl(): string
    {
        return $this->app_background
        ? url('storage/' . $this->app_background)
        : asset('images/default/background.jpg');
    }
}
