<?php

namespace App\Models;

use App\Traits\DurationScopeTrait;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SaleOrder extends Model
{
    use Filterable, DurationScopeTrait;

    protected $fillable = [
        'uuid', 'is_cash_paid',
        'name', 'phone', 'email',
        'cart_total_cost',
        'cart_total_items',
        'cart_total_price',
        'cart_total_profit',
        'tax',
        'tax_amount', 'customer_id',
        'shipping',
        'discount',
        'payable_after_all',
        'profit_after_all',
        'recepient_amount',
        'change_amount',
        'note',
        'tracking',
        'id',
        'items', 'display_note',
        'print_display_note', 'user_id', 'warranty_note',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'items' => 'json',
        'tax' => 'json',
        'print_display_note' => 'boolean',
        'is_cash_paid' => 'boolean',
    ];

    /**
     * Setting default route key
     *
     * @return string
     */
    public function getRouteKeyName(): string
    {
        return 'uuid';
    }

    /**
     * Get the products for the sale order
     *
     * @return HasMany
     */
    public function saleOrderProducts(): HasMany
    {
        return $this->hasMany(SaleOrderProduct::class, 'sale_order_id');
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
