<?php

namespace App\Models;

use App\Traits\DurationScopeTrait;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Repair extends Model
{
    use Filterable, DurationScopeTrait;

    protected $fillable = ['status', 'imei', 'tracking', 'uuid', 'issue', 'device_name', 'charges', 'serial_number', 'tax', 'tax_amount', 'due', 'pre_paid', 'total_amount', 'by', 'message', 'profit', 'cost', 'user_id', 'cash_book_id', 'is_cash_paid', 'customer_id'];

    /**
     * Setting default route key
     *
     * @return string
     */
    public function getRouteKeyName(): string
    {
        return 'uuid';
    }

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'status' => 'boolean',
        'tax' => 'json',
        'is_cash_paid' => 'boolean',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
