<?php

namespace App\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProductAttribute extends Model
{
    use Filterable;

    protected $fillable = ['product_id', 'title', 'cost', 'price', 'ws_price', 'serial_number', 'identity', 'sku', 'upc', 'is_serial_based', 'supplier_id', 'warehouse_id',
    ];

    protected $casts = [
        'is_serial_based' => 'boolean',
    ];
    /**
     * Product information belongs to attribute
     *
     * @return     BelongsTo  The belongs to.
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Product supplier
     *
     * @return     BelongsTo  The belongs to.
     */
    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    /**
     * Product stocks
     *
     * @return     HasMany  The has many.
     */
    public function stocks(): HasMany
    {
        return $this->hasMany(Stock::class);
    }

    public function getTotalInStock()
    {
        return $this->stocks->sum('quantity');
    }

    public function getTotalSoldStock()
    {
        return $this->stocks->sum('sold');
    }
}
