<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class SupplierFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string           $search  The search
     *
     * @return     WarehouseFilter  The warehouse filter.
     */
    public function search($search): SupplierFilter
    {
        return $this->where('last_name', 'LIKE', '%' . $search . '%')
            ->orWhere('first_name', 'LIKE', '%' . $search . '%')
            ->orWhere('email', 'LIKE', '%' . $search . '%')
            ->orWhere('phone', 'LIKE', '%' . $search . '%')
            ->orWhere('address', 'LIKE', '%' . $search . '%')
            ->orWhere('company', 'LIKE', '%' . $search . '%')
            ->orWhere('date_of_birth', 'LIKE', '%' . $search . '%');
    }
}
