<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class StockFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string          $search  The search
     *
     * @return     StockFilter  The stock filter.
     */
    public function search($search): StockFilter
    {
        return $this->where('tracking', 'LIKE', '%' . $search . '%')
            ->orWhere('product_id', 'LIKE', '%' . $search . '%');
    }
}
