<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class SaleOrderFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return SaleOrderFilter
     */
    public function search($search): SaleOrderFilter
    {
        return $this->where('tracking', 'LIKE', '%' . $search . '%')
            ->orWhere('note', 'LIKE', '%' . $search . '%')
            ->orWhere('shipping', 'LIKE', '%' . $search . '%')
            ->orWhere('payable_after_all', 'LIKE', '%' . $search . '%')
            ->orWhere('recepient_amount', 'LIKE', '%' . $search . '%')
            ->orWhere('change_amount', 'LIKE', '%' . $search . '%')
            ->orWhereHas('saleOrderProducts', function ($query) use ($search) {
                $query->where('name', 'LIKE', '%' . $search . '%')
                    ->orWhere('title', 'LIKE', '%' . $search . '%')
                    ->orWhere('serial_number', 'LIKE', '%' . $search . '%')
                    ->orWhere('identity', 'LIKE', '%' . $search . '%');
            })
            ->orWhereHas('customer', function ($query) use ($search) {
                $query->where('name', 'LIKE', '%' . $search . '%')
                    ->orWhere('email', 'LIKE', '%' . $search . '%')
                    ->orWhere('phone', 'LIKE', '%' . $search . '%')
                    ->orWhere('address', 'LIKE', '%' . $search . '%');
            });
    }
}
