<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class RepairFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return RepairFilter
     */
    public function search($search): RepairFilter
    {
        return $this->Where('tracking', 'LIKE', '%' . $search . '%')
            ->orWhere('serial_number', 'LIKE', '%' . $search . '%')
            ->orWhere('imei', 'LIKE', '%' . $search . '%')
            ->orWhere('charges', 'LIKE', '%' . $search . '%')
            ->orWhere('message', 'LIKE', '%' . $search . '%')
            ->orWhere('device_name', 'LIKE', '%' . $search . '%')
            ->orWhere('issue', 'LIKE', '%' . $search . '%')
            ->orWhere('total_amount', 'LIKE', '%' . $search . '%')
            ->orWhereHas('customer', function ($query) use ($search) {
                $query->where('name', 'LIKE', '%' . $search . '%')
                    ->orWhere('email', 'LIKE', '%' . $search . '%')
                    ->orWhere('phone', 'LIKE', '%' . $search . '%')
                    ->orWhere('address', 'LIKE', '%' . $search . '%');
            });
    }
}
