<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class ProductFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string         $search  The search
     *
     * @return     ProductFilter  The product filter.
     */
    public function search($search): ProductFilter
    {
        return $this->where('name', 'LIKE', '%' . $search . '%')
            ->orWhere('upc', 'LIKE', '%' . $search . '%')
            ->orWhere('sku', 'LIKE', '%' . $search . '%')
            ->orWhere('serial_number', 'LIKE', '%' . $search . '%')
            ->orWhere('identity', 'LIKE', '%' . $search . '%')
            ->orWhereHas('productAttributes', function ($query) use ($search) {
                $query->where('title', 'LIKE', '%' . $search . '%')
                    ->orWhere('upc', 'LIKE', '%' . $search . '%')
                    ->orWhere('sku', 'LIKE', '%' . $search . '%')
                    ->orWhere('serial_number', 'LIKE', '%' . $search . '%')
                    ->orWhere('identity', 'LIKE', '%' . $search . '%');
            });
    }

    /**
     * Filter by category
     *
     * @param      string       $category  The category
     *
     * @return     ProductFilter  The product filter.
     */
    public function category($category): ProductFilter
    {
        return $this->where('category_id', $category);
    }

    /**
     * Filter by supplier
     *
     * @param      String         $supplier  The supplier
     *
     * @return     ProductFilter  The product filter.
     */
    public function supplier($supplier): ProductFilter
    {
        return $this->where('supplier_id', $supplier);
    }
}
