<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class ProductAttributeFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * Searches for the first match.
     *
     * @param      string           $search  The search
     *
     * @return     ProductAttributeFilter  The category filter.
     */
    public function search($search): ProductAttributeFilter
    {
        return $this->where('title', 'LIKE', '%' . $search . '%')
            ->orWhere('sku', 'LIKE', '%' . $search . '%')
            ->orWhere('serial_number', 'LIKE', '%' . $search . '%')
            ->orWhere('identity', 'LIKE', '%' . $search . '%')
            ->orWhere('upc', 'LIKE', '%' . $search . '%')
            ->orWhereHas('product', function ($query) use ($search) {
                $query->where('name', 'LIKE', '%' . $search . '%')
                    ->orWhere('upc', 'LIKE', '%' . $search . '%')
                    ->orWhere('sku', 'LIKE', '%' . $search . '%');
            });
    }

}
