<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class CustomProductFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return CustomProductFilter
     */
    public function search($search): CustomProductFilter
    {
        return $this->Where('key', 'LIKE', '%' . $search . '%')
            ->orWhere('uuid', 'LIKE', '%' . $search . '%')
            ->orWhere('model', 'LIKE', '%' . $search . '%')
            ->orWhere('imei', 'LIKE', '%' . $search . '%')
            ->orWhere('serial_number', 'LIKE', '%' . $search . '%')
            ->orWhere('id', 'LIKE', '%' . $search . '%')
            ->orWhereHas('customer', function ($query) use ($search) {
                $query->where('name', 'LIKE', '%' . $search . '%')
                    ->orWhere('email', 'LIKE', '%' . $search . '%')
                    ->orWhere('phone', 'LIKE', '%' . $search . '%')
                    ->orWhere('address', 'LIKE', '%' . $search . '%');
            });
    }
}
