<?php

namespace App\Models\Filters;

use EloquentFilter\ModelFilter;

class CustomBillFilter extends ModelFilter
{
    /**
     * Related Models that have ModelFilters as well as the method on the ModelFilter
     * As [relationMethod => [input_key1, input_key2]].
     *
     * @var array
     */
    public $relations = [];

    /**
     * User dataTable search query
     *
     * @param mixed $search query
     *
     * @return CustomBillFilter
     */
    public function search($search): CustomBillFilter
    {
        return $this->where('tracking', 'LIKE', '%' . $search . '%')
            ->orWhere('date', 'LIKE', '%' . $search . '%')
            ->orWhere('time', 'LIKE', '%' . $search . '%')
            ->orWhere('charges', 'LIKE', '%' . $search . '%')
            ->orWhere('description', 'LIKE', '%' . $search . '%')
            ->orWhere('total_amount', 'LIKE', '%' . $search . '%')
            ->orWhere('tax', 'LIKE', '%' . $search . '%')
            ->orWhere('tax_amount', 'LIKE', '%' . $search . '%')
            ->orWhere('tracking', 'LIKE', '%' . $search . '%')
            ->orWhereHas('customer', function ($query) use ($search) {
                $query->where('name', 'LIKE', '%' . $search . '%')
                    ->orWhere('email', 'LIKE', '%' . $search . '%')
                    ->orWhere('phone', 'LIKE', '%' . $search . '%')
                    ->orWhere('address', 'LIKE', '%' . $search . '%');
            });
    }
}
