<?php

namespace App\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Notifications\Notifiable;

class Customer extends Model
{
    use HasFactory, Filterable, Notifiable;

    protected $fillable = ['uuid', 'name', 'email', 'phone', 'address', 'vat_id'];

    /**
     * Setting default route key
     *
     * @return string
     */
    public function getRouteKeyName(): string
    {
        return 'uuid';
    }

    /**
     * Sale under customer
     *
     * @return     HasMany  The has many.
     */
    public function saleOrders(): HasMany
    {
        return $this->hasMany(SaleOrder::class, 'customer_id');
    }

    public function repairs(): HasMany
    {
        return $this->hasMany(Repair::class, 'customer_id');
    }

    public function customProducts(): HasMany
    {
        return $this->hasMany(CustomProduct::class, 'customer_id');
    }

    public function customBills(): HasMany
    {
        return $this->hasMany(CustomBill::class, 'customer_id');
    }

    public function canRemove(): bool
    {
        return $this->saleOrders->count() < 1
        && $this->repairs->count() < 1
        && $this->id > 1
        && $this->customProducts->count() < 1
        && $this->customBills->count() < 1;
    }

    public function routeNotificationForVonage()
    {
        return $this->phone;
    }

    public function routeNotificationForTwilio()
    {
        return $this->phone;
    }
}
