<?php

namespace App\Models;

use App\Traits\DurationScopeTrait;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CustomProduct extends Model
{

    use Filterable, DurationScopeTrait;

    protected $fillable = [
        'key', 'uuid', 'image', 'docs', 'customer_id', 'model', 'imei', 'serial_number', 'cost', 'price', 'is_sold', 'sign', 'saleable', 'user_id', 'grade', 'condition',
        'more',
    ];

    /**
     * Setting default route key
     *
     * @return string
     */
    public function getRouteKeyName(): string
    {
        return 'uuid';
    }

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'is_sold' => 'boolean',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
