<?php

namespace App\Models;

use App\Traits\DurationScopeTrait;
use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CustomBill extends Model
{

    use Filterable, DurationScopeTrait;

    protected $fillable = ['uuid', 'tracking', 'customer_id', 'date', 'time', 'charges', 'description', 'tax', 'tax_amount', 'total_amount', 'items', 'by', 'user_id'];

    /**
     * Setting default route key
     *
     * @return string
     */
    public function getRouteKeyName(): string
    {
        return 'uuid';
    }

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'items' => 'json',
        'tax' => 'json',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
