<?php

namespace App\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Category extends Model
{

    use Filterable;

    protected $fillable = ['name', 'slug', 'image'];

    /**
     * Main categories
     *
     * @return     BelongsTo  The belongs to.
     */
    public function parent(): BelongsTo
    {
        return $this->belongsTo(static::class, 'parent_id');
    }

    /**
     * Subcategories
     *
     * @return     HasMany  The has many.
     */
    public function subcategories(): HasMany
    {
        return $this->hasMany(static::class, 'parent_id');
    }

    /**
     * Products under category
     *
     * @return     HasMany  The has many.
     */
    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }

    /**
     * User avatar url
     *
     * @return string
     */
    public function getImageUrl(): string
    {
        return $this->image
        ? url('storage/' . $this->image)
        : asset('images/default/category.png');
    }
}
