<?php

namespace App\Http\View\Composers;

use App\Models\Setting;
use Illuminate\View\View;

class AppComposer
{

    protected $configs;

    public function __construct()
    {
        $this->configs = Setting::find(1);
    }

    /**
     * Application configuration for injecting to views
     *
     * @param View $view view
     */
    public function compose(View $view)
    {
        $view->with('fav_icon', $this->configs->getLogoUrl())
            ->with(
                'app_data',
                [
                    'url' => url('/'),
                    'name' => $this->configs->app_name,
                    'phone' => $this->configs->app_phone,
                    'address' => $this->configs->app_address,
                    'register' => $this->configs->app_user_registration,
                    'app_logo_url' => $this->configs->getLogoUrl(),
                    'app_background_url' => $this->configs->getBackgroundUrl(),
                    'recaptcha_enabled' => $this->configs->recaptcha_enabled,
                    'recaptcha_public' => $this->configs->recaptcha_public,
                    'app_date_format' => $this->configs->app_date_format,
                    'app_date_locale' => $this->configs->app_date_locale,
                    'app_timezone' => $this->configs->app_timezone,
                    'invoice_setup' => $this->configs->invoice_setup,
                    'is_demo_mode' => config('app.demo_mode'),
                    'version' => config('app.version'),
                    'app_direction' => config('app.direction'),
                    'terms' => $this->getInvoiceTerms(),
                    'pos_setup' => $this->posSetup(),
                    'currency_setup' => $this->getCurrencySetup(),
                    'application_pack' => $this->getApplicationPack(),
                    'tax_setup' => $this->getTaxConfig(),
                    'noa' => true,
                    'auto_printable' => false,
                ]
            );
    }

    public function getApplicationPack()
    {
        return config('app.pack', null);
    }

    protected function posSetup()
    {
        return [
            'default_warehouse_id' => $this->configs->default_warehouse_id,
            'pos_categories_default_numbers' => $this->configs->pos_categories_default_numbers,
            'pos_monies' => $this->configs->pos_monies,
            'pos_products_default_numbers' => $this->configs->pos_products_default_numbers,
            'pos_scanner_focus_autofocus' => $this->configs->pos_scanner_focus_autofocus,
            'pos_scanner_focus_duration' => $this->configs->pos_scanner_focus_duration,
            'pos_scanner_processing_delay' => $this->configs->pos_scanner_processing_delay,
        ];
    }

    protected function getTaxConfig()
    {
        return [
            'rate' => (int) $this->configs->tax_rate,
            'tax_rate' => (int) $this->configs->tax_rate,
            'is_tax_fix' => (bool) $this->configs->is_tax_fix,
            'is_tax_included' => (bool) $this->configs->is_tax_included,
            'tax_id' => $this->configs->tax_id,
            'is_vat' => (bool) $this->configs->is_vat,
        ];
    }

    protected function getCurrencySetup()
    {
        return [
            'currency_symbol' => $this->configs->currency_symbol,
            'currency_symbol_on_left' => $this->configs->currency_symbol_on_left,
            'currency_shorthand_notation' => $this->configs->currency_shorthand_notation,
            'currency_space_between' => $this->configs->currency_space_between,
        ];
    }

    protected function getInvoiceTerms()
    {
        return [
            'sales' => $this->configs->sale_invoice_terms,
            'repairs' => $this->configs->repair_invoice_terms,
            'bills' => $this->configs->bill_invoice_terms,
            'custom_products' => $this->configs->custom_buy_invoice_terms,
        ];
    }
}
