<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class StockResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'product_id' => $this->product_id,
            'product_name' => $this->product->name,
            'product_attribute_id' => $this->product_attribute_id,
            'warehouse_name' => $this->warehouse->name,
            'warehouse_id' => $this->warehouse_id,
            'quantity' => $this->quantity,
            'sold' => $this->sold,
            'rack_number' => $this->rack_number,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
