<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SaleResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'cart_total_cost' => $this->cart_total_cost,
            'cart_total_items' => $this->cart_total_items,
            'cart_total_price' => $this->cart_total_price,
            'cart_total_profit' => $this->cart_total_profit,
            'serial_number' => $this->serial_number,
            'tax_amount' => $this->tax_amount,
            'shipping' => $this->shipping,
            'discount' => $this->discount,
            'payable_after_all' => $this->payable_after_all,
            'profit_after_all' => $this->profit_after_all,
            'recepient_amount' => $this->recepient_amount,
            'change_amount' => $this->change_amount,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
