<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use App\Http\Resources\SaleOrderProductDetailResource;
use Illuminate\Http\Resources\Json\JsonResource;

class SaleOrderPrintResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'cart_total_items' => $this->cart_total_items,
            'sub_total' => $this->cart_total_price,
            'tax' => $this->tax,
            'tax_amount' => $this->tax_amount,
            'shipping' => $this->shipping,
            'discount' => $this->discount,
            'payable' => $this->payable_after_all,
            'recepient_amount' => $this->recepient_amount,
            'change_amount' => $this->change_amount,
            'warranty_note' => $this->warranty_note,
            'items' => SaleOrderProductDetailResource::collection($this->saleOrderProducts),
            'qr_link' => url('/print/sale-order/' . $this->uuid),
            'print_display_note' => $this->print_display_note,
            'display_note' => $this->display_note,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
