<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use App\Http\Resources\SaleOrderProductDetailResource;
use Illuminate\Http\Resources\Json\JsonResource;

class SaleOrderDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'customer' => new CustomerResource($this->customer),
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'cart_total_cost' => $this->cart_total_cost,
            'cart_total_items' => $this->cart_total_items,
            'serial_number' => $this->serial_number,
            'sub_total' => $this->cart_total_price,
            'tax' => $this->tax,
            'tax_amount' => $this->tax_amount,
            'shipping' => $this->shipping,
            'discount' => $this->discount,
            'payable' => $this->payable_after_all,
            'expected_profit' => $this->cart_total_profit,
            'profit_after_all' => $this->profit_after_all,
            'recepient_amount' => $this->recepient_amount,
            'change_amount' => $this->change_amount,
            'note' => $this->note,
            'warranty_note' => $this->warranty_note,
            'items' => SaleOrderProductDetailResource::collection($this->saleOrderProducts),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
