<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ReportSoldProductsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'name' => $this->title ? $this->name . ' ' . $this->title : $this->name,
            'identity' => $this->identity,
            'serial_number' => $this->serial_number,
            'price' => $this->price,
            'qty' => $this->qty,
            'sub_total' => $this->sub_total,
        ];
    }
}
