<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ReportRepairedItemsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'issue' => $this->issue,
            'model' => $this->device_name,
            'charges' => $this->charges,
            'total_amount' => $this->total_amount,
            'tracking' => $this->tracking,
            'imei' => $this->imei,
            'serial_number' => $this->serial_number,
            'profit' => $this->profit,
        ];
    }
}
