<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RepairTrackDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'name' => $this->name,
            'device_name' => $this->device_name,
            'issue' => $this->issue,
            'message' => $this->message,
            'serial_number' => $this->serial_number,
            'imei' => $this->imei,
            'charges' => $this->charges,
            'pre_paid' => $this->pre_paid,
            'due' => $this->due,
            'status' => $this->status,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
