<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RepairResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'device_name' => $this->device_name,
            'serial_number' => $this->serial_number,
            'imei' => $this->imei,
            'charges' => $this->charges,
            'prepaid' => $this->pre_paid,
            'due' => $this->due,
            'status' => $this->status,
            'customer' => new CustomerResource($this->customer),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
