<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use Illuminate\Http\Resources\Json\JsonResource;

class RepairDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'device_name' => $this->device_name,
            'issue' => $this->issue,
            'message' => $this->message,
            'serial_number' => $this->serial_number,
            'imei' => $this->imei,
            'charges' => $this->charges,
            'tax' => $this->tax,
            'tax_amount' => $this->tax_amount,
            'pre_paid' => $this->pre_paid,
            'due' => $this->due,
            'cost' => $this->cost,
            'profit' => $this->profit,
            'status' => $this->status,
            'notify_email' => false,
            'notify_sms' => true,
            'is_cash_paid' => $this->is_cash_paid,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
