<?php

namespace App\Http\Resources;

use App\Http\Resources\WarehouseResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductStockResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'quantity' => $this->quantity,
            'sold' => $this->sold ?? 0,
            'product_id' => $this->product_id,
            'product_attribute_id' => $this->product_attribute_id,
            'warehouse_id' => $this->warehouse_id,
            'returned' => $this->returned ?? 0,
            'rack_number' => $this->rack_number ?? 1,
            'warehouse' => new WarehouseResource($this->warehouse),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
