<?php

namespace App\Http\Resources;

use App\Http\Resources\CategoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'status' => $this->status,
            'price' => $this->price,
            'cost' => $this->cost,
            'has_variants' => $this->has_variants,
            'variants' => $this->has_variants ? count($this->productAttributes) : 0,
            'alert_at' => $this->low_qty_alert,
            'category' => new CategoryResource($this->category),
            'avatar' => $this->image,
            'avatar_url' => $this->getImageUrl(),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
