<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductLabelResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->product_id ? $this->product->name . ' (' . $this->title . ')' : $this->name,
            'sku' => $this->sku,
            'price' => $this->price,
            'barcode' => $this->upc,
            'identity' => $this->identity,
            'serial_number' => $this->serial_number,
            'available' => $this->getTotalInStock(),
        ];
    }
}
