<?php

namespace App\Http\Resources;

use App\Http\Resources\CategoryResource;
use App\Http\Resources\ProductAttributeResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $product = [
            'id' => $this->id,
            'name' => $this->name,
            'slug' => $this->slug,
            'status' => $this->status,
            'has_variants' => $this->has_variants,
            'description' => $this->description,
            'low_qty_alert' => $this->low_qty_alert,
            'tax_type' => $this->tax_type,
            'identity' => $this->identity,
            'image' => $this->image,
            'image_url' => $this->getImageUrl(),
            'category' => new CategoryResource($this->category),
            'supplier_id' => $this->supplier_id,
            'warehouse_id' => $this->warehouse_id,
            'barcode_symbology' => $this->barcode_symbology,
            'price' => $this->price,
            'cost' => $this->cost,
            'next' => $this->next(),
            'previous' => $this->previous(),
            'is_serial_based' => $this->is_serial_based,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
        if ($this->has_variants) {
            $product['stocks'] = [];
            $product['variants'] = ProductAttributeResource::collection($this->productAttributes);
        } else {
            $product['serial_number'] = $this->serial_number;
            $product['sku'] = $this->sku;
            $product['upc'] = $this->upc;
            $product['stocks'] = ProductStockResource::collection($this->stocks);
        }
        return $product;
    }
}
