<?php

namespace App\Http\Resources;

use App\Http\Resources\ProductStockResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductAttributeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'category_id' => $this->product->category_id,
            'supplier_id' => $this->supplier_id,
            'warehouse_id' => $this->warehouse_id,
            'supplier' => $this->supplier,
            'stocks' => ProductStockResource::collection($this->stocks),
            'sku' => $this->sku,
            'upc' => $this->upc,
            'cost' => $this->cost,
            'price' => $this->price,
            'ws_price' => $this->ws_price,
            'qty' => $this->getTotalInStock(),
            'is_serial_based' => $this->is_serial_based,
            'serial_number' => $this->serial_number,
            'identity' => $this->identity,
            'maximize' => env('PRODUCT_MINIMIZE', false),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
