<?php

namespace App\Http\Resources;

use App\Http\Resources\PosProductAttributesResource;
use Illuminate\Http\Resources\Json\JsonResource;

class PosSearchProductsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'category_id' => $this->category_id,
            'name' => $this->name,
            'image' => $this->getImageUrl(),
            'sku' => $this->sku,
            'upc' => $this->upc,
            'cost' => $this->cost,
            'price' => $this->price,
            'ws_price' => $this->ws_price,
            'has_variants' => $this->has_variants,
            'identity' => $this->identity,
            'serial_number' => $this->serial_number,
            'in_stock' => $this->getTotalInStock(),
            'variants' => PosProductAttributesResource::collection($this->productAttributes),
        ];
    }
}
