<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PosProductAttributesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $data = [
            'id' => $this->product->id,
            'attribute_id' => $this->id,
            'name' => $this->product->name,
            'title' => $this->title,
            'identity' => $this->identity,
            'sku' => $this->sku,
            'upc' => $this->upc,
            'serial_number' => $this->serial_number,
            'image' => $this->product->getImageUrl(),
            'price' => $this->price,
            'cost' => $this->price,
            'in_stock' => $this->getTotalInStock(),
        ];

        if (null !== $this->product->warranty_label) {
            $data['warranty_label'] = '0' == $this->product->warranty_label ? __('Warranty') : __('Grantee');
            $data['warranty_value'] = $this->product->warranty_value;
        }
        return $data;
    }
}
