<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DashboardLastSoldProductsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'name' => $this->title ? $this->name . ' ' . $this->title : $this->name,
            'price' => $this->price,
            'identity' => $this->identity,
            'serial_number' => $this->serial_number,
            'qty' => $this->qty,
            'image' => $this->image,
            'sub_total' => $this->sub_total,
        ];
    }
}
