<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->key,
            'customer' => new CustomerResource($this->customer),
            'model' => $this->model,
            'imei' => $this->imei,
            'cost' => $this->cost,
            'price' => $this->price,
            'qty' => $this->qty,
            'is_sold' => $this->is_sold,
            'image' => $this->image,
            'docs' => $this->docs,
            'photo' => $this->photo,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
