<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomProductPrintResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->key,
            'customer' => new CustomerResource($this->customer),
            'model' => $this->model,
            'imei' => $this->imei,
            'more' => $this->more,
            'condition' => $this->condition,
            'grade' => $this->grade,
            'serial_number' => $this->serial_number,
            'price' => $this->cost,
            'qty' => $this->qty,
            'image_url' => $this->image ? url('/storage/' . $this->image) : null,
            'docs_url' => $this->docs ? url('/storage/' . $this->docs) : null,
            'qr_link' => url('/print/custom-product/' . $this->uuid),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
