<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomProductDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->key,
            'customer' => new CustomerResource($this->customer),
            'customer_id' => $this->customer_id,
            'model' => $this->model,
            'imei' => $this->imei,
            'grade' => $this->grade,
            'condition' => $this->condition,
            'more' => $this->more,
            'serial_number' => $this->serial_number,
            'cost' => $this->cost,
            'price' => $this->price,
            'qty' => $this->qty,
            'sign' => $this->sign,
            'is_sold' => $this->is_sold,
            'image' => $this->image,
            'image_url' => $this->image ? url('/storage/' . $this->image) : null,
            'docs' => $this->docs,
            'docs_url' => $this->docs ? url('/storage/' . $this->docs) : null,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
