<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomBillPrintResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'items' => $this->items,
            'date' => $this->date,
            'time' => $this->time,
            'charges' => $this->charges,
            'description' => $this->description,
            'tax' => $this->tax,
            'tax_amount' => $this->tax_amount,
            'total_amount' => $this->total_amount,
            'tax' => $this->tax,
            'qr_link' => url('/print/custom-bill/' . $this->uuid),
        ];
    }
}
