<?php

namespace App\Http\Resources;

use App\Http\Resources\CustomerResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomBillDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'tracking' => $this->tracking,
            'customer' => new CustomerResource($this->customer),
            'customer_id' => $this->customer_id,
            'date' => $this->date,
            'time' => $this->time,
            'charges' => $this->charges,
            'description' => $this->description,
            'tax' => $this->tax,
            'total_amount' => $this->total_amount,
            'tax_amount' => $this->tax_amount,
            'items' => $this->items,
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
