<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RepairRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer_id' => 'required',
            'device_name' => 'required|max:255',
            'imei' => 'required|max:255',
            'serial_number' => 'required|max:255',
            'charges' => 'required|max:255',
            'tax' => 'required',
            'tax_amount' => 'required|max:255',
            'issue' => 'required',
            'message' => 'nullable',
            'status' => 'sometimes',
            'pre_paid' => 'required',
            'due' => 'required',
            'total_amount' => 'required',
            'cost' => 'required',
            'profit' => 'required',
            'notify_email' => 'sometimes',
            'notify_sms' => 'sometimes',
            'is_cash_paid' => 'required',
        ];
    }
}
